function [logL, theta, derivatives]=EstimTCanonicalVine(data,initialparams,optimizer)
% Estimate parameters and derivatives (numerically evaluated) of a
% canonical vine, assuming static T Copula for all pairs.
% This function estimates the parameters of all pair copula simultaneously.
% It is significantly slower than the EstimateTCanonicalVine.m. Before you
% use this run EstimateTCanonicalVine.m, and use the output as initial
% values for this. For standard errors, use this function, with fminunc as
% optimizer
% INPUTS:
% data:             A TxN matrix with U(0,1) or iid margins
% initialparams:    Use the output of EstimateTCanonicalVine.m, column
%                   matrix with N(N-1)/2 rows
% optimizer:        String with values 'fmincon' or 'fminunc'. fmincon is
%                   much more stable but fminunc is for calculating derivatives
%------------------------------------------------------------------------
% Author: Manthos Vogiatzoglou, UoM, 2009
% contact at: vogia@yahoo.com
%------------------------------------------------------------------------
display('------------------------------------------------------------------------')
display('this function is very slow!')
display('------------------------------------------------------------------------')
display('if you do not care about std errors run EstimateTCanonicalVine.m instead')
display('------------------------------------------------------------------------')
[T,N]=size(data);
options = optimset('Display','iter','MaxFunEvals',10000,'TolCon',10^-12,'TolFun',10^-4,'TolX',10^-4);
if strcmp(optimizer,'fminunc')
if isempty(initialparams)
initialparams=2.5*ones(N*(N-1)/2,1);
end
[theta, likhood,exitflag,output,grad,hessian]= fminunc('TCopCVineLL',initialparams,options,data,optimizer);
derivatives.grad=grad;
derivatives.hessian=hessian;
logL = TCopCVineLL(theta,data);
elseif strcmp(optimizer,'fmincon')
if isempty(initialparams)
initialparams=15*ones(N*(N-1)/2,1);
end
lower=2.01*ones(N*(N-1)/2,1);
upper=300*ones(N*(N-1)/2,1);
[theta, logL]= fmincon('TCopCVineLL',initialparams,[],[],[],[],lower,upper,[],options,data,optimizer);
derivatives=[];
end